//Editbox Control Example//
#include <windows.h>
#define ID_EDIT 1
#define ID_BUTTON 2
LRESULT CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
WNDCLASSEX wc;
MSG msg;
wc.cbSize = sizeof(WNDCLASSEX);
wc.style = 0;
wc.lpfnWndProc = WndProc;
wc.cbClsExtra = 0;
wc.cbWndExtra = 0;
wc.hInstance = hInstance;
wc.hIcon = LoadIcon(NULL, IDI_APPLICATION);
wc.hCursor = LoadCursor(NULL, IDC_ARROW);
wc.hbrBackground = (HBRUSH)(COLOR_WINDOW + 1);
wc.lpszMenuName = NULL;
wc.lpszClassName = TEXT("myWindowClass");
wc.hIconSm = LoadIcon(NULL, IDI_APPLICATION);
RegisterClassEx(&wc);
CreateWindowEx(WS_EX_CLIENTEDGE, TEXT("myWindowClass"), TEXT("Edit Box Demo"), WS_VISIBLE | WS_OVERLAPPEDWINDOW, CW_USEDEFAULT, CW_USEDEFAULT, 700, 350, NULL, NULL, hInstance, NULL);
while (GetMessage(&msg, NULL, 0, 0) > 0)
{
TranslateMessage(&msg);
DispatchMessage(&msg);
}
return msg.wParam;
}


LRESULT CALLBACK WndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam) {
HWND static hwndEdit,hwndButton,hwndStatic;
switch(msg) {
// The WM_CREATE message is sent to the window procedure after the window is created, but before the window becomes visible.
case WM_CREATE:
//3 child windows are registered
hwndEdit = CreateWindow(TEXT("edit"), NULL,WS_CHILD | WS_VISIBLE | WS_BORDER,20, 60, 250, 30, hwnd, (HMENU) ID_EDIT,NULL, NULL);//edit control
hwndStatic=CreateWindow(TEXT("static"), NULL,WS_BORDER | WS_CHILD | WS_VISIBLE | SS_LEFT,20, 20, 250, 30,hwnd, (HMENU) 1, NULL, NULL);//static control
hwndButton = CreateWindow(TEXT("button"), TEXT("Click Me"),WS_VISIBLE | WS_CHILD, 20, 100, 80, 30,hwnd, (HMENU) ID_BUTTON, NULL, NULL);//click button
break;
case WM_COMMAND:
//responds to button click
if (HIWORD(wParam) == BN_CLICKED) {
const int maxtextlength = 30;
TCHAR textvalue[maxtextlength] = TEXT("");
//gets value of textbox and stores in 'textvalue'
GetWindowText(hwndEdit, textvalue, maxtextlength);
//changes text in static box to value in 'textvalue'
SetWindowText(hwndStatic, textvalue);
}
break;
case WM_DESTROY:
PostQuitMessage(0);
break;
}
return DefWindowProc(hwnd, msg, wParam, lParam);
}